declare enum RealtimeLensType {
    Path = "path",
    Search = "search",
    Storage = "storage",
    Form = "form",
    Javascript = "javascript",
    Dom = "dom"
}
declare enum RealtimeProfileMergeType {
    DisableMerge = 0,
    MergeRegisterVisit = 1,
    MergeOnly = 2
}
declare enum RealtimeContextSearch {
    IncludeSubcontexts = 0,
    ExactPath = 1,
    IncludeParentContexts = 2,
    FirstParent = 3
}
declare enum RealtimeTrackingMode {
    Standard = 0,
    NoTracking = 1,
    Preview = 2
}
declare class RpiWebClient {
    private defaults;
    private realtimeParameters;
    private location;
    private isInitialized;
    private data;
    private lensConfig;
    private formLensFieldValues;
    private doNotTrack;
    decisionOptions: RpiDecisionOptions;
    pageParameters: RpiPageParameters;
    config: RpiWebClientConfig;
    visitor: VisitorCookie;
    private LOAD_EVENT;
    private PRE_INIT_EVENT;
    private INIT_VISITOR_EVENT;
    private ACTIVATE_LENSES_EVENT;
    private INIT_EVENT;
    private RENDER_CONTEXT_EVENT;
    private RENDER_SMART_ASSET_EVENT;
    private RENDER_LOOKUP_EVENT;
    private VISITOR_SET_EVENT;
    private VISITOR_CHANGE_EVENT;
    private DECISION_RESULT_CLICK_EVENT;
    private DECISION_RESULT_LOAD_EVENT;
    private DECISION_TAG_LOAD_EVENT;
    private DECISION_RECOMMENDATION_LOAD_EVENT;
    private LensType;
    constructor();
    init(opts?: RpiWebClientConfig, callback?: () => void): void;
    private initCallback;
    private log;
    private subscribeEvent;
    private unsubscribeEvent;
    private publishEvent;
    private parseUri;
    private serializeQueryString;
    private parseMatchPattern;
    private setElementData;
    private getElementData;
    private setLocalStorageItem;
    private getLocalStorageItem;
    private detectBrowser;
    private detectDoNotTrack;
    private getUuid;
    private activateLenses;
    private activateLens;
    private activateStorageLens;
    private storageLensRetryHandler;
    private activatePathLens;
    private pathLensHandler;
    private activateSearchLens;
    private searchLensHandler;
    private activateJsLens;
    private jSLensHandler;
    private activateFormLens;
    private formLensHandler;
    private formLensInputHandler;
    private activateDomLens;
    private domLensHandler;
    private pushLensParameter;
    private getFormByNameOrId;
    private getFormByIndex;
    private eval;
    private isNumeric;
    private parseRpiPageParams;
    submitVisitorDetails(callback?: (data: string) => void): void;
    getSmartAssetDecisions(smartAssetDecisions: Array<SmartAssetDecision>, callback: (data: SmartAssetResponse) => void, isMasterMessage?: boolean): void;
    renderSmartAssetDecisions(smartAssetDecisions: Array<SmartAssetDecision>, callback?: (data: SmartAssetResponse) => void): void;
    getContextDecision(contextPath: string, callback: (data: Array<ApiDecisionResult>) => void, returnAll?: boolean): void;
    getContextDecisions(contextPaths: Array<string>, callback: (data: Array<ApiDecisionResult>) => void, returnAll?: boolean): void;
    private getContextSmartAssetDecisions;
    renderContextDecision(contextPath: string): void;
    renderContextDecisions(contextPaths: Array<string>): void;
    getDecision(publishId: string, isMasterMessage: boolean, callback: (data: Array<ApiDecisionResult>) => void): void;
    getDecisions(publishIds: Array<string>, callback: (data: Array<ApiDecisionResult>, contentDecisions?: Array<ContentDecision>) => void): void;
    renderDecision(contentId: string, elementId: string): void;
    renderDecisions(contentDecisions: Array<ContentDecision>): void;
    private cacheDecisionResults;
    getCachedVisitor(callback: (data: string) => void): void;
    getVisitorView(viewName: string, callback: (data: ApiVisitorView) => void): void;
    private getLookupAttributes;
    private renderLookupAttributes;
    private submitVisitorRequestAsync;
    private parseResponseJSON;
    private registerForCrossDomainTracking;
    private appendCrossDomainTrackingDetails;
    private attachClickEventHandler;
    private registerForClickEvents;
    private webEventClickHandler;
    private initRealtimeParameters;
    private initPageEvents;
    private getVisitorRegistrationDetails;
    private getApiSmartAssetRequest;
    private getCacheParametersRequest;
    private requestGeolocation;
    private queueWebEvent;
    pushWebEvent(state: string, stateValue: string | null, extraParam?: string | null, contentId?: string | null, metadata?: Array<ApiEventMetadata>): void;
    private flushPendingEvents;
    private sendMetric;
    private sendLinkClickEvent;
    private getEventRequestDetails;
    renderDecisionContent(result: ApiDecisionResult, elementId?: string | null, lookupRequest?: string): void;
    private getElementId;
    private getDomElement;
    private parseHtml;
    getDecisionContent(result: ApiDecisionResult, callback: (content: string) => void, lookupRequest?: string): void;
    pushRealtimeParameter(name: string, value: string, isListParam?: boolean, listOperator?: string): void;
    flushRealtimeParameters(callback?: (data: string) => void): void;
    private requestAsync;
    private postRequestAsync;
    private getCookie;
    private setCookie;
    private getVisitorCookie;
    private setVisitorCookie;
    private parseVisitorResponse;
    private parseVisitor;
    private setGeolocationExpiry;
    private getApiServer;
    private getCacheVisitUrl;
    private getCacheParametersUrl;
    private getCacheVisitorsAttributesUrl;
    private getCacheCachedAttributesUrl;
    private getEventsUrl;
    private getVisitorViewUrl;
    private getDecisionsSmartAssetsUrl;
    private shouldUseXhrCredentials;
    private getXhr;
    _setFormTracking(): void;
    private _submitCacheDBData;
    _cacheDBData(lookupId: string, lookupValue: string): void;
    _pushPageGoal(goalName: string, stateName: string, goalDetail: string, contentIds: string): void;
    _submitFBParams(FB: any, edges: Array<string>, reload: boolean): void;
}
declare var rpiWebClient: RpiWebClient;
