if (window.rpiWebClient) { // check if RpiWebClient is already loaded
    initLiveRampPlugin();
} else { // set an event listener if RpiWebClient hasn't been loaded
    window.addEventListener("rpiWebClientLoad", function (event) {
        initLiveRampPlugin();
    });
}

function initLiveRampPlugin() {
    RpiWebClient.prototype.liverampPixelUrl = "https://id.rlcdn.com/709634.gif";
    RpiWebClient.prototype.identityLinkParameterName = "IdentityLink";
    RpiWebClient.prototype.IDENTITYLINK_SET_EVENT = "rpiVisitorIdentityLinkSet";
    RpiWebClient.prototype.identityLinkRetryThreshold = 10;
    RpiWebClient.prototype.identityLinkRetryInterval = 1000;
    RpiWebClient.prototype.identityLinkRetryCount = 0;
    RpiWebClient.prototype.identityLinkRequestExpiry = 30;

    RpiWebClient.prototype.hasIdentityLink = function () {
        if (rpiWebClient.visitor.profile.HasAlternativeKey) {
            for (var i = 0; i < rpiWebClient.visitor.profile.Keys.length; i++) {
                var key = rpiWebClient.visitor.profile.Keys[i];
                if (key.KeyName == rpiWebClient.identityLinkParameterName && key.IsKnown) {
                    return true;
                }
            }
        }

        return false;
    }

    RpiWebClient.prototype.checkForIdentityLink = function () {
        rpiWebClient.getCachedVisitor(function (data) {
            if (rpiWebClient.hasIdentityLink()) {
                rpiWebClient.log("IdentityLink found in profile!");
                // trigger rpiVisitorIdentityLinkSet
                rpiWebClient.publishEvent(rpiWebClient.IDENTITYLINK_SET_EVENT, rpiWebClient);

            } else if (rpiWebClient.identityLinkRetryCount < rpiWebClient.identityLinkRetryThreshold) {
                rpiWebClient.log("IdentityLink not found...");
                setTimeout(function () {
                    rpiWebClient.checkForIdentityLink();
                }, rpiWebClient.identityLinkRetryInterval);

                rpiWebClient.identityLinkRetryCount++;
            }
        });
    }

    RpiWebClient.prototype.setIdentityLinkExpiry = function () {
        var today = new Date();
        var expiry = new Date(today.toString());
        expiry.setDate(expiry.getDate() + rpiWebClient.identityLinkRequestExpiry);
        rpiWebClient.visitor.identityLinkExpiry = expiry.valueOf();

        rpiWebClient.setVisitorCookie();
    }

    RpiWebClient.prototype.subscribeEvent(window, "rpiWebClientInitVisitor", function (event) {
        rpiWebClient.log("Preparing to drop LiveRamp redirect pixel...", "INFO");

        if (!rpiWebClient.visitor.identityLinkExpiry || rpiWebClient.visitor.identityLinkExpiry < Date.now()) {
            rpiWebClient.setIdentityLinkExpiry();

            if (rpiWebClient.hasIdentityLink()) {
                rpiWebClient.log("Visitor profile contains " + rpiWebClient.identityLinkParameterName + ", skipping...", "INFO");

                return;
            }

            // visitor profile does not contain an identityLink -- drop pixel
            var pixel = document.createElement("img");
            var cparams = "visitorID=" + rpiWebClient.visitor.profile.VisitorID;
            pixel.src = rpiWebClient.liverampPixelUrl + "?cparams=" + encodeURIComponent(cparams);

            var body = document.getElementsByTagName("body");
            body[0].appendChild(pixel);

            rpiWebClient.log("LiveRamp redirect pixel dropped with cparams: " + cparams, "INFO");

            setTimeout(function () {
                rpiWebClient.checkForIdentityLink();
            }, rpiWebClient.identityLinkRetryInterval);
        } else {
            rpiWebClient.log("LiveRamp redirect pixel requested within last " + rpiWebClient.identityLinkRequestExpiry + " days, skipping...", "INFO");
        }
    });
}