interface RpiWebClientConfig {
    debug?: boolean;
    clientId?: string;
    serverUrl?: string;
    enableClickTracking?: boolean;
    enablePageVisitTracking?: boolean;
    visitorCookieDuration?: number;
    realtimeCookieDomain?: string;
    realtimeCookieSameSite?: string;
    serverCookieEnabled?: boolean;
    enableUrlParameterCaching?: boolean;
    urlParameterCachingOverrides?: Array<string>;
    requestGeolocation?: boolean;
    geolocationCookieDuration?: number;
    contexts?: Array<string>;
    smartAssetDecisions?: Array<SmartAssetDecision>;
    enableCrossDomainTracking?: false;
    trackingDomains?: Array<string>;
    realtimeListParameters?: Array<string>;
    visitorProfileMergeMode?: number;
    realtimeContextSearchMode?: number;
    enableDoNotTrack?: boolean;
    isPreview?: boolean;
}
interface RpiPageParameters {
    pageTitle: string;
    goals: Array<ApiGoal>;
    pendingEvents: Array<ApiEvent>;
    impressionId: string;
    cId: string;
    exId: number;
    geolocation: Position | null;
    pagePublishId: string;
}
interface RealtimeParameter {
    Name: string;
    Value?: string;
    ValueList?: Array<string>;
    ValueJSON?: object;
    UpdateOperator?: string;
}
interface VisitorCookie {
    profile: ApiVisitor;
    geolocationExpiry: number;
}
interface PageLocation {
    [key: string]: any;
    href: string;
    raw: string;
    protocol: string;
    host: string;
    hostName: string;
    port: string;
    pathName: string;
    directoryPath: string;
    fileName: string;
    search: string;
    hash: string;
    pathParts: Array<string>;
    searchParts: Record<string, string>;
}
interface RpiWebClientDataLayer {
    decisionResults: Array<ApiDecisionResult>;
    lensResults: Array<RealtimeParameter>;
    tags: any;
    recommendations: any;
}
interface RpiDecisionOptions {
    isContextLookup?: boolean;
    lookupRequest?: string;
    masterMessageDivs?: Array<string>;
    defaultContentAddress?: string;
    numberOfResults?: number;
    applyNumberResultsToNested?: boolean;
    minuteOffsetUTC?: string;
    apiContext?: string;
}
interface ContentDecision {
    contentId: string;
    elementId: string;
    RecommendationRanks?: DecisionRecommendationRanks;
}
interface SmartAssetDecision {
    PublishID?: string;
    ElementID?: string;
    ContextSearch?: SmartAssetDecisionContextSearch;
    ResultOptions?: SmartAssetDecisionResultOptions;
}
interface SmartAssetDecisionContextSearch {
    ContextPath?: string;
    SearchOperator?: number;
    TagSearch?: string;
}
interface SmartAssetDecisionResultOptions {
    RecommendationRanks?: DecisionRecommendationRanks;
    NumberOfResults?: number;
    ApplyNumberResultsToNested?: boolean;
    ReturnAll?: boolean;
}
interface DecisionRecommendationRanks {
    MinimumRank: number;
    MaximumRank: number;
    ReturnAll: boolean;
}
interface ApiEvent {
    state: string;
    stateValue: string | null;
    extraParam: string | null;
    contentID: string | null;
    metadata?: Array<ApiEventMetadata>;
}
interface ApiEventMetadata {
    Name: string;
    Value: string;
}
interface ApiEventRequest {
    VisitorID: string;
    DeviceID: string;
    EventName: string;
    EventDetail: string;
    MetricValue: string;
    ClientID: string;
    ChannelExecutionID: string;
    RPContactID: string;
    PagePublishID: string;
    ContentID: string;
    GoalDetails: ApiEventGoalDetails;
    PageReferral: string;
    RequestURL: string;
    ImpressionID: string;
    Metadata: ApiEventMetadata;
}
interface ApiEventGoalDetails {
    GoalName: string;
    GoalContentID: string;
    DecisionResults: Array<ApiEventDecisionResults>;
    GoalAssets: Array<string>;
}
interface ApiEventDecisionResults {
    ContentID: string;
    IndexResult: string;
    PublishedInstanceID: string;
    PageName: string;
}
interface ApiCacheParameterRequest {
    VisitorID: string;
    Parameters: Array<RealtimeParameter>;
}
interface ApiDecisionResult {
    ContentName: string;
    ResultID: string;
    ContentID: string;
    Result: string;
    ResultContent: any;
    ResultContentXML: string;
    ContentFormat: string;
    IsCachedContent: boolean;
    DefaultKey: string;
    DivName: string;
    ContentPath: string;
    IsEmptyResult: boolean;
    PluginTag: string;
    PluginTagDefault: string;
    ContextName: string;
    SlotName: string;
    ContextTag: string;
    VisitorID: string;
    DecisionType: string;
    ChannelExecutionID: number;
    RPContactID: string;
    TriggerKey: string;
    ErrorMessage: string;
}
interface SmartAssetResponse {
    Results: Array<ApiDecisionResult>;
    Visitor: ApiVisitor;
}
interface ApiSmartAssetRequest {
    DeviceID?: string;
    ImpressionID?: string;
    Identity?: ApiSmartAssetRequestIdentity;
    ProfileMergeMode?: number;
    VisitDetails?: ApiSmartAssetRequestVisitDetails;
    AssetLookups?: Array<ApiSmartAssetRequestAssetLookup>;
    PagePublishedID?: string;
    Parameters?: Array<RealtimeParameter>;
    RequestURL?: string;
    Geolocation?: ApiSmartAssetRequestGeolocation;
    MinuteOffsetUTC?: string;
    APIContext?: string;
    IsMasterMessage?: boolean;
    InteractionTracking?: ApiSmartAssetRequestInteractionTracking;
    TrackingMode?: RealtimeTrackingMode;
}
interface ApiSmartAssetRequestIdentity {
    VisitorID: string;
    IdentityKeys?: any;
}
interface ApiSmartAssetRequestVisitDetails {
    IsNewVisitor?: boolean;
    PageReferrer?: string;
    ViewName?: string;
}
interface ApiSmartAssetRequestAssetLookup extends SmartAssetDecision {
}
interface ApiSmartAssetRequestContextSearch extends SmartAssetDecisionContextSearch {
}
interface ApiSmartAssetRequestResultOptions extends SmartAssetDecisionResultOptions {
}
interface ApiSmartAssetRequestRecommendationRanks extends DecisionRecommendationRanks {
}
interface ApiSmartAssetRequestInteractionTracking {
    ChannelExecutionID?: number;
    RPContactID?: string;
}
interface ApiSmartAssetRequestGeolocation {
    Longitude: number;
    Latitude: number;
    SearchString?: string;
}
interface ApiDecisionRequest {
    Identity?: ApiSmartAssetRequestIdentity;
    DecisionRequest?: ApiDecisionRequestDetail;
    AssetLookups?: Array<ApiSmartAssetRequestAssetLookup>;
}
interface ApiDecisionRequestDetail {
    NumberOfResults?: number;
    ApplyNumberResultsToNested?: boolean;
    DeviceID?: string;
    ImpressionID?: string;
    PublishID?: string;
    MinuteOffsetUTC?: string;
    APIContext?: string;
    IsMasterMessage?: boolean;
    Attributes?: Array<RealtimeParameter>;
    Geolocation?: ApiSmartAssetRequestGeolocation;
    RequestURL?: string;
    RecommendationRanks?: DecisionRecommendationRanks;
}
interface ApiVisitorView {
    VisitorID: string;
    ViewName: string;
    Values: Array<ApiViewValue>;
}
interface ApiViewValue {
    Name: string;
    Value: string;
    ValueCollection: Array<string>;
    IsCollection: boolean;
}
interface ApiIdentityLookup {
    VisitorID: string;
    IdentityKeys?: Array<string>;
}
interface ApiVisitorViewArguments {
    Identity: ApiIdentityLookup;
    Attributes: Array<RealtimeParameter> | null;
    TrackingMode?: RealtimeTrackingMode;
}
interface ApiVisitor {
    VisitorID: string;
    DeviceID?: string;
    ImpressionID?: string;
    IsMasterKey: boolean;
    HasAlternativeKey: boolean;
    Keys: Array<ApiVisitorKey>;
    View?: ApiVisitorView;
}
interface ApiVisitorKey {
    KeyName: string;
    IsKnown: boolean;
}
interface ApiDynamicContent {
    divName: string;
    contentId: string;
    defaultKey: string;
    isCachedContent: boolean;
}
interface ApiValueLookupResult {
    ID: string;
    Value: string;
}
interface ApiGoal {
    name: string;
    state: string;
    detail: string;
    content: string;
}
interface Lens {
    type: RealtimeLensType;
    name?: string;
    id?: string;
}
interface LensParameter {
    name: string;
    isListParam: boolean;
    trackLastViewed?: boolean;
    lastViewedParameterName?: string;
    valueMapEnabled: boolean;
    valueMap: Map<string, string>;
    isStrictValueMap: boolean;
}
interface StorageLens extends Lens {
    storageType: string;
    lookupKey: string;
    realtimeParameter: LensParameter;
    retry: boolean;
    retryCount?: number;
    retryDelayMs?: number;
}
interface SearchLens extends Lens {
    searchParameter: string;
    realtimeParameter: LensParameter;
    timeoutMs?: number;
}
interface PathPart {
    index: number;
    realtimeParameter: LensParameter;
}
interface PathLens extends Lens {
    urlPattern: string;
    pathParts: Array<PathPart>;
    timeoutMs?: number;
}
interface JsLens extends Lens {
    objectName: string;
    realtimeParameter: LensParameter;
    timeoutMs?: number;
}
interface FormLensInput {
    inputNameOrId: string;
    realtimeParameter: LensParameter;
}
interface FormLens extends Lens {
    formNameOrId?: string;
    formIndex?: number;
    formInputs: Array<FormLensInput>;
    timeoutMs?: number;
}
interface DomLens extends Lens {
    selectors: string;
    index?: number;
    attribute?: string;
    realtimeParameter: LensParameter;
    timeoutMs?: number;
}
interface LensConfig {
    Lenses: Array<StorageLens | SearchLens | PathLens | JsLens | FormLens>;
}
interface Window {
    attachEvent(eventName: string, listener: EventListener): boolean;
    detachEvent(eventName: string, listener: EventListener): void;
    fireEvent(eventName: string, event: object): void;
    rpiRealtimeClickWebEventTimeout: number;
    readonly doNotTrack: string;
}
interface Document {
    createEventObject(): any;
    attachEvent(eventName: string, listener: EventListener): boolean;
    detachEvent(eventName: string, listener: EventListener): void;
}
interface HTMLElement {
    attachEvent(eventName: string, listener: EventListener): boolean;
    detachEvent(eventName: string, listener: EventListener): void;
}
interface Position {
    readonly coords: Coordinates;
}
interface Coordinates {
    readonly latitude: number;
    readonly longitude: number;
}
interface PositionError {
    readonly code: number;
    readonly message: string;
}
