'use strict';

customElements.define('compodoc-menu', class extends HTMLElement {
    constructor() {
        super();
        this.isNormalMode = this.getAttribute('mode') === 'normal';
    }

    connectedCallback() {
        this.render(this.isNormalMode);
    }

    render(isNormalMode) {
        let tp = lithtml.html(`
        <nav>
            <ul class="list">
                <li class="title">
                    <a href="index.html" data-type="index-link">Application documentation</a>
                </li>

                <li class="divider"></li>
                ${ isNormalMode ? `<div id="book-search-input" role="search"><input type="text" placeholder="Type to search"></div>` : '' }
                <li class="chapter">
                    <a data-type="chapter-link" href="index.html"><span class="icon ion-ios-home"></span>Getting started</a>
                    <ul class="links">
                        <li class="link">
                            <a href="overview.html" data-type="chapter-link">
                                <span class="icon ion-ios-keypad"></span>Overview
                            </a>
                        </li>
                        <li class="link">
                            <a href="index.html" data-type="chapter-link">
                                <span class="icon ion-ios-paper"></span>README
                            </a>
                        </li>
                        <li class="link">
                            <a href="changelog.html"  data-type="chapter-link">
                                <span class="icon ion-ios-paper"></span>CHANGELOG
                            </a>
                        </li>
                        <li class="link">
                            <a href="contributing.html"  data-type="chapter-link">
                                <span class="icon ion-ios-paper"></span>CONTRIBUTING
                            </a>
                        </li>
                        <li class="link">
                            <a href="license.html"  data-type="chapter-link">
                                <span class="icon ion-ios-paper"></span>LICENSE
                            </a>
                        </li>
                        <li class="link">
                            <a href="todo.html"  data-type="chapter-link">
                                <span class="icon ion-ios-paper"></span>TODO
                            </a>
                        </li>
                    </ul>
                </li>
                    <li class="chapter additional">
                        <div class="simple menu-toggler" data-toggle="collapse" ${ isNormalMode ? 'data-target="#additional-pages"'
                            : 'data-target="#xs-additional-pages"' }>
                            <span class="icon ion-ios-book"></span>
                            <span>Additional documentation</span>
                            <span class="icon ion-ios-arrow-down"></span>
                        </div>
                        <ul class="links collapse " ${ isNormalMode ? 'id="additional-pages"' : 'id="xs-additional-pages"' }>
                                    <li class="chapter inner">
                                        <a data-type="chapter-link" href="additional-documentation/realtime-lenses.html" data-context-id="additional">
                                            <div class="menu-toggler linked" data-toggle="collapse" ${ isNormalMode ?
                                            'data-target="#additional-page-18734b1a0cfa5111e234c131f05a92d3d1568c87049e5969deb509297483f8de4f897e7654b8bda2dba6d9bc70e331706f5d441f445bd649962c8a9eeeb483f5"' : 'data-target="#xs-additional-page-18734b1a0cfa5111e234c131f05a92d3d1568c87049e5969deb509297483f8de4f897e7654b8bda2dba6d9bc70e331706f5d441f445bd649962c8a9eeeb483f5"' }>
                                                <span class="link-name">Realtime Lenses</span>
                                                <span class="icon ion-ios-arrow-down"></span>
                                            </div>
                                        </a>
                                        <ul class="links collapse" ${ isNormalMode ? 'id="additional-page-18734b1a0cfa5111e234c131f05a92d3d1568c87049e5969deb509297483f8de4f897e7654b8bda2dba6d9bc70e331706f5d441f445bd649962c8a9eeeb483f5"' : 'id="xs-additional-page-18734b1a0cfa5111e234c131f05a92d3d1568c87049e5969deb509297483f8de4f897e7654b8bda2dba6d9bc70e331706f5d441f445bd649962c8a9eeeb483f5"' }>
                                            <li class="link for-chapter2">
                                                <a href="additional-documentation/realtime-lenses/path-lens-settings.html" data-type="entity-link" data-context="sub-entity" data-context-id="additional">Path Lens Settings</a>
                                            </li>
                                            <li class="link for-chapter2">
                                                <a href="additional-documentation/realtime-lenses/search-lens-settings.html" data-type="entity-link" data-context="sub-entity" data-context-id="additional">Search Lens Settings</a>
                                            </li>
                                            <li class="link for-chapter2">
                                                <a href="additional-documentation/realtime-lenses/storage-lens-settings.html" data-type="entity-link" data-context="sub-entity" data-context-id="additional">Storage Lens Settings</a>
                                            </li>
                                            <li class="link for-chapter2">
                                                <a href="additional-documentation/realtime-lenses/javascript-lens-settings.html" data-type="entity-link" data-context="sub-entity" data-context-id="additional">Javascript Lens Settings</a>
                                            </li>
                                            <li class="link for-chapter2">
                                                <a href="additional-documentation/realtime-lenses/form-lens-settings.html" data-type="entity-link" data-context="sub-entity" data-context-id="additional">Form Lens Settings</a>
                                            </li>
                                            <li class="link for-chapter2">
                                                <a href="additional-documentation/realtime-lenses/dom-lens-settings.html" data-type="entity-link" data-context="sub-entity" data-context-id="additional">DOM Lens Settings</a>
                                            </li>
                                        </ul>
                                    </li>
                        </ul>
                    </li>
                    <li class="chapter">
                        <div class="simple menu-toggler" data-toggle="collapse" ${ isNormalMode ? 'data-target="#classes-links"' :
                            'data-target="#xs-classes-links"' }>
                            <span class="icon ion-ios-paper"></span>
                            <span>Classes</span>
                            <span class="icon ion-ios-arrow-down"></span>
                        </div>
                        <ul class="links collapse " ${ isNormalMode ? 'id="classes-links"' : 'id="xs-classes-links"' }>
                            <li class="link">
                                <a href="classes/RpiWebClient.html" data-type="entity-link" >RpiWebClient</a>
                            </li>
                        </ul>
                    </li>
                    <li class="chapter">
                        <div class="simple menu-toggler" data-toggle="collapse" ${ isNormalMode ? 'data-target="#interfaces-links"' :
                            'data-target="#xs-interfaces-links"' }>
                            <span class="icon ion-md-information-circle-outline"></span>
                            <span>Interfaces</span>
                            <span class="icon ion-ios-arrow-down"></span>
                        </div>
                        <ul class="links collapse " ${ isNormalMode ? ' id="interfaces-links"' : 'id="xs-interfaces-links"' }>
                            <li class="link">
                                <a href="interfaces/ApiCacheParameterRequest.html" data-type="entity-link" >ApiCacheParameterRequest</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/ApiDecisionResult.html" data-type="entity-link" >ApiDecisionResult</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/ApiEvent.html" data-type="entity-link" >ApiEvent</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/ApiEventDecisionResults.html" data-type="entity-link" >ApiEventDecisionResults</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/ApiEventGoalDetails.html" data-type="entity-link" >ApiEventGoalDetails</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/ApiEventMetadata.html" data-type="entity-link" >ApiEventMetadata</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/ApiValueLookupResult.html" data-type="entity-link" >ApiValueLookupResult</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/ApiViewValue.html" data-type="entity-link" >ApiViewValue</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/ApiVisitorView.html" data-type="entity-link" >ApiVisitorView</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/ContentDecision.html" data-type="entity-link" class="deprecated-name">ContentDecision</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/DecisionRecommendationRanks.html" data-type="entity-link" >DecisionRecommendationRanks</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/DomLens.html" data-type="entity-link" >DomLens</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/FormLens.html" data-type="entity-link" >FormLens</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/JsLens.html" data-type="entity-link" >JsLens</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/Lens.html" data-type="entity-link" >Lens</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/LensConfig.html" data-type="entity-link" >LensConfig</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/LensParameter.html" data-type="entity-link" >LensParameter</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/PageLocation.html" data-type="entity-link" >PageLocation</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/PathLens.html" data-type="entity-link" >PathLens</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/PathPart.html" data-type="entity-link" >PathPart</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/RpiDecisionOptions.html" data-type="entity-link" >RpiDecisionOptions</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/RpiWebClientConfig.html" data-type="entity-link" >RpiWebClientConfig</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/RpiWebClientDataLayer.html" data-type="entity-link" >RpiWebClientDataLayer</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/SearchLens.html" data-type="entity-link" >SearchLens</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/SmartAssetDecision.html" data-type="entity-link" >SmartAssetDecision</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/SmartAssetResponse.html" data-type="entity-link" >SmartAssetResponse</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/StorageLens.html" data-type="entity-link" >StorageLens</a>
                            </li>
                            <li class="link">
                                <a href="interfaces/VisitorCookie.html" data-type="entity-link" >VisitorCookie</a>
                            </li>
                        </ul>
                    </li>
                    <li class="chapter">
                        <div class="simple menu-toggler" data-toggle="collapse" ${ isNormalMode ? 'data-target="#miscellaneous-links"'
                            : 'data-target="#xs-miscellaneous-links"' }>
                            <span class="icon ion-ios-cube"></span>
                            <span>Miscellaneous</span>
                            <span class="icon ion-ios-arrow-down"></span>
                        </div>
                        <ul class="links collapse " ${ isNormalMode ? 'id="miscellaneous-links"' : 'id="xs-miscellaneous-links"' }>
                            <li class="link">
                                <a href="miscellaneous/enumerations.html" data-type="entity-link">Enums</a>
                            </li>
                            <li class="link">
                                <a href="miscellaneous/variables.html" data-type="entity-link">Variables</a>
                            </li>
                        </ul>
                    </li>
                    <li class="divider"></li>
                    <li class="copyright">
                        Documentation generated using <a href="https://compodoc.app/" target="_blank">
                            <img data-src="images/compodoc-vectorise.png" class="img-responsive" data-type="compodoc-logo">
                        </a>
                    </li>
            </ul>
        </nav>
        `);
        this.innerHTML = tp.strings;
    }
});